using System;
using System.Drawing;
using System.Collections;
using System.Reflection;

using Microsoft.DirectX;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.SharedDLL
{
	public class Region
	{
		public Region()
		{
		}
		public virtual Vector2 ConvertToPointLocation()
		{
			Vector2 vRetVal = Vector2.Empty;
			return( vRetVal );
		}
		public virtual RegionPoint HitTest( Region oTestRegion )
		{
			if( this.GetType() == typeof( RegionCircle ) )
			{
				RegionCircle oRegion1 = (RegionCircle)this;

				if( oTestRegion.GetType() == typeof( RegionCircle ) )
				{
					RegionCircle oRegion2 = (RegionCircle)oTestRegion;
					if( DSMath.Distance( oRegion1.Center,oRegion2.Center ) < oRegion1.Radius + oRegion2.Radius )
					{
						float nXDiff = oRegion2.Center.X - oRegion1.Center.X;
						float nYDiff = oRegion2.Center.Y - oRegion1.Center.Y;
						float nPerc = oRegion1.Radius / ( oRegion1.Radius + oRegion2.Radius );
						Vector2 vCenter = new Vector2( oRegion1.Center.X + nXDiff * nPerc,oRegion1.Center.Y + nYDiff * nPerc );
						return( new RegionPoint( vCenter ) );
					}
				}
				else if( oTestRegion.GetType() == typeof( RegionPoint ) )
				{
					RegionPoint oRegion2 = (RegionPoint)oTestRegion;
					if( DSMath.Distance( oRegion1.Center,oRegion2.Center ) < oRegion1.Radius )
					{
						return( new RegionPoint( oRegion2.Center ) );
					}
				}
				else if( oTestRegion.GetType() == typeof( RegionLine ) )
				{
					double nDistToCol = 0;
					double nDist = 0;
					double nAngleOfLine = 0;
					Vector2 vImpactPoint = Vector2.Empty;
					RegionLine oRegion2 = (RegionLine)oTestRegion;

					nDist = DSMath.GetDistanceToLineFromPoint( oRegion2.StartPt,oRegion2.StopPt,oRegion1.Center,ref vImpactPoint );
					if( nDist < oRegion1.Radius )
					{
						//Find the closest colision point to the circle
						nDistToCol = Math.Sqrt( oRegion1.Radius * oRegion1.Radius - nDist * nDist );

						//Our colision point isn't quite right
						nAngleOfLine = DSMath.CalculateRadAngle( oRegion2.StartPt.X,-oRegion2.StartPt.Y,oRegion2.StopPt.X,-oRegion2.StopPt.Y );
						nAngleOfLine += Math.PI;
						vImpactPoint = new Vector2( (float)( vImpactPoint.X + Math.Cos( nAngleOfLine ) * nDistToCol ),
													(float)( vImpactPoint.Y - Math.Sin( nAngleOfLine ) * nDistToCol ) );

						return( new RegionPoint( vImpactPoint ) );
					}
				}
			}
			else if( this.GetType() == typeof( RegionPoint ) )
			{
				RegionPoint oRegion1 = (RegionPoint)this;

				if( oTestRegion.GetType() == typeof( RegionCircle ) )
				{
					RegionCircle oRegion2 = (RegionCircle)oTestRegion;
					return( oRegion2.HitTest( this ) );
				}
				else if( oTestRegion.GetType() == typeof( RegionPoint ) )
				{
					RegionPoint oRegion2 = (RegionPoint)oTestRegion;
					if( oRegion1.Center == oRegion2.Center )
					{
						return( new RegionPoint( oRegion2.Center ) );
					}
				}
				else if( oTestRegion.GetType() == typeof( RegionLine ) )
				{
					double nDist = 0;
					Vector2 vImpactPoint = Vector2.Empty;
					RegionLine oRegion2 = (RegionLine)oTestRegion;

					nDist = DSMath.GetDistanceToLineFromPoint( oRegion2.StartPt,oRegion2.StopPt,oRegion1.Center,ref vImpactPoint );
					if( nDist < .01 )
					{
						return( new RegionPoint( oRegion1.Center ) );
					}
				}
			}
			else if( this.GetType() == typeof( RegionLine ) )
			{
				RegionLine oRegion1 = (RegionLine)this;

				if( oTestRegion.GetType() == typeof( RegionCircle ) )
				{
					RegionCircle oRegion2 = (RegionCircle)oTestRegion;
					return( oRegion2.HitTest( this ) );
				}
				else if( oTestRegion.GetType() == typeof( RegionPoint ) )
				{
					RegionPoint oRegion2 = (RegionPoint)oTestRegion;
					return( oRegion2.HitTest( this ) );
				}
				else if( oTestRegion.GetType() == typeof( RegionLine ) )
				{
					RegionLine oRegion2 = (RegionLine)oTestRegion;
					//					!!! Do line line collision
				}
			}

			return( null );
		}


		public static bool IsEmpty( Region oRegion )
		{
			return( oRegion == null || oRegion.GetType() == typeof( Region ) );
		}

	}

	public class RegionCircle : Region
	{
		#region Properties
		private Vector2 m_vCenter = Vector2.Empty;
		private float m_nRadius = 0;
		#endregion

		public RegionCircle( Vector2 vCenter,float nRadius )
		{
			m_vCenter = vCenter;
			m_nRadius = nRadius;
		}

		public override Vector2 ConvertToPointLocation()
		{
			Vector2 vRetVal = this.Center;
			return( vRetVal );
		}


		#region Properties
		public Vector2 Center
		{
			get
			{
				return( m_vCenter );
			}
		}
		public float Radius
		{
			get
			{
				return( m_nRadius );
			}
		}
		#endregion
	}

	public class RegionPoint : Region
	{
		#region Properties
		private Vector2 m_vCenter = Vector2.Empty;
		#endregion

		public RegionPoint( Vector2 vCenter )
		{
			m_vCenter = vCenter;
		}
		public override Vector2 ConvertToPointLocation()
		{
			Vector2 vRetVal = this.Center;
			return( vRetVal );
		}


		#region Properties
		public Vector2 Center
		{
			get
			{
				return( m_vCenter );
			}
		}
		#endregion
	}

	public class RegionLine : Region
	{
		#region Properties
		private Vector2 m_vStartPt = Vector2.Empty;
		private Vector2 m_vStopPt = Vector2.Empty;
		#endregion

		public RegionLine( Vector2 vStartPt,Vector2 vStopPt )
		{
			m_vStartPt = vStartPt;
			m_vStopPt = vStopPt;
		}

		public override Vector2 ConvertToPointLocation()
		{
			Vector2 vRetVal = m_vStartPt;
			return( vRetVal );
		}

        
		#region Properties
		public Vector2 StartPt
		{
			get
			{
				return( m_vStartPt );
			}
		}
		public Vector2 StopPt
		{
			get
			{
				return( m_vStopPt );
			}
		}
		#endregion
	}
}
